import sys
import pandas as pd
from pandas import Series
import math
import numpy as np
np.set_printoptions(precision=4, suppress=True)

from numpy import genfromtxt

import matplotlib
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap
colormap = ListedColormap(['Blue', 'Green', 'White'])

import scipy
from scipy import stats
from scipy.stats import randint
from scipy.spatial.distance import pdist


import seaborn as sns
import statsmodels
import statsmodels.api as sm
import sklearn
from sklearn.linear_model import LinearRegression, LogisticRegression
from sklearn.metrics import mean_squared_error,  r2_score, accuracy_score, classification_report, confusion_matrix
from sklearn.tree import DecisionTreeRegressor, DecisionTreeClassifier, export_graphviz
from sklearn.neighbors import KNeighborsRegressor
from sklearn.ensemble import BaggingRegressor, BaggingClassifier, RandomForestRegressor, RandomForestClassifier,AdaBoostRegressor, GradientBoostingRegressor, AdaBoostClassifier, GradientBoostingClassifier
from sklearn.neural_network import MLPRegressor, MLPClassifier
from sklearn.model_selection import GridSearchCV, RandomizedSearchCV
from sklearn.datasets import make_circles, make_classification 

from IPython.display import Image

from itertools import product

from mpl_toolkits import mplot3d
import pickle
sns.set(color_codes=True)
sns.set(rc={'figure.figsize':(16,5)})


def versions():
    pd.set_option('display.max_rows',30)
    if IPython.version_info==(7, 6, 1, ''): 
        iPython='7.6.1' 
    elif IPython.version_info!=(7, 6, 1, ''): 
        iPython='NaN'
    table = [

                          
                          ['Python', sys.version[:5], 'NaN'],
                          ['IPython', iPython, 'IPython'],
                          ['math', NaN, 'math'],
                          ['matplotlib.pyplot, pylab', matplotlib.__version__, 'plt'],
                          ['numpy', numpy.__version__, 'np'],
                          ['pandas', pd.__version__, 'pd'],        
                          ['pickle', pickle.format_version, 'pickle'],
                          ['random', NaN, 'random'],
                          ['scipy', scipy.__version__, 'scipy'],        
                          ['sklearn', sklearn.__version__, 'sklearn'],
                          ['statsmodels', sm.__version__, 'sm'],
                          ['tabulate', tabulate.__version__, 'tabulate'],

    ]
    table=pd.DataFrame(data=table)
    table.columns = ['Package', 'Version', 'Acronym']
    print(table)
    pd.set_option('display.max_rows',10)
   
  
def datagen_reg(n_obs):
    from sklearn.preprocessing import PolynomialFeatures

    np.random.seed(1234)
    N_sim = n_obs
    mu, sigma = 0, 0.4
    
    X_train = np.random.uniform(low=0.0, high=1.3, size=N_sim)
    eps_train = np.random.normal(mu, sigma, N_sim)
    y_train = np.sin(5 * X_train) + eps_train
    
    np.random.seed(14)
    X_test = np.random.uniform(low=0.0, high=1.3, size=N_sim)
    eps_test = np.random.normal(mu, sigma, N_sim)
    y_test = np.sin(5 * X_test) + eps_test
    
    poly = PolynomialFeatures(1, include_bias=False)
    X_train=poly.fit_transform(X_train.reshape(-1, 1))
    X_test=poly.fit_transform(X_test.reshape(-1, 1))
    
    return X_train, y_train, X_test, y_test

def datagen_class(n):
    from sklearn.datasets import make_circles, make_classification 
    from matplotlib.colors import ListedColormap
    colormap = ListedColormap(['Blue', 'Green', 'White'])
    np.random.seed(1234)
    
    tmp1 = make_circles(n_samples=n, noise=0.2, factor=0.5, random_state=1)
    X_train = tmp1[0]
    y_train = tmp1[1] * 2 - 1 # transform to (-1,+1)

    tmp2 = make_circles(n_samples=n, noise=0.2, factor=0.5, random_state=2)

    X_test = tmp2[0]
    y_test = tmp2[1] * 2 - 1
    
    return X_train, y_train, X_test, y_test